/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExpandJar {
    public static String expand(URL jar) throws IOException {
        return ExpandJar.expand(jar, System.getProperty("java.io.tmpdir"));
    }

    public static String expand(URL jar, String workFolder) throws IOException {
        int slash;
        int period;
        String pathname = jar.toString().replace('\\', '/');
        if (pathname.endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        return ExpandJar.expand(jar, pathname, workFolder);
    }

    public static String expand(URL jar, String pathname, String dirname) throws IOException {
        File appBase = new File(dirname);
        File docBase = new File(appBase, pathname);
        if (!docBase.mkdir()) {
            throw new IllegalStateException(String.format("Unable to create directory: %s", docBase.getAbsolutePath()));
        }
        JarURLConnection juc = (JarURLConnection)jar.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input2 = null;
        try {
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                int last2 = name.lastIndexOf(47);
                if (last2 >= 0 && !(parent = new File(docBase, name.substring(0, last2))).mkdirs()) {
                    throw new IllegalStateException(String.format("Unable to create directory: %s", parent.getAbsolutePath()));
                }
                if (name.endsWith("/")) continue;
                input2 = jarFile.getInputStream(jarEntry);
                ExpandJar.expand(input2, docBase, name);
                input2.close();
                input2 = null;
            }
        }
        catch (IOException e) {
            ExpandJar.deleteDir(docBase);
            throw e;
        }
        finally {
            if (input2 != null) {
                try {
                    input2.close();
                }
                catch (Throwable ignored) {}
                input2 = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable ignored) {}
                jarFile = null;
            }
        }
        return docBase.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest) {
        boolean result2 = true;
        String[] files2 = null;
        if (src.isDirectory()) {
            files2 = src.list();
            result2 = dest.mkdir();
        } else {
            files2 = new String[]{""};
        }
        if (files2 == null) {
            files2 = new String[]{};
        }
        for (int i = 0; i < files2.length && result2; ++i) {
            File fileSrc = new File(src, files2[i]);
            File fileDest = new File(dest, files2[i]);
            if (fileSrc.isDirectory()) {
                result2 = ExpandJar.copy(fileSrc, fileDest);
                continue;
            }
            FileChannel ic = null;
            AbstractInterruptibleChannel oc = null;
            try {
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                continue;
            }
            catch (IOException e) {
                result2 = false;
                continue;
            }
            finally {
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException ignored) {}
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return result2;
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            return ExpandJar.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        String[] files2 = dir.list();
        if (files2 == null) {
            files2 = new String[]{};
        }
        for (int i = 0; i < files2.length; ++i) {
            File file = new File(dir, files2[i]);
            if (file.isDirectory()) {
                ExpandJar.deleteDir(file);
                continue;
            }
            if (file.delete()) continue;
            throw new IllegalStateException(String.format("Unable to delete file: %s", file.getAbsolutePath()));
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void expand(InputStream input2, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input2.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

